package net.w_horse.excelpojo.excel.cellseeker;

import java.lang.annotation.Annotation;

import net.w_horse.excelpojo.ExcelPOJOBridge;
import net.w_horse.excelpojo.ExcelPOJOException;
import net.w_horse.excelpojo.annotation.ExcelPOJOAnnotationParser;
import net.w_horse.excelpojo.converter.CellFieldConverter;
import net.w_horse.excelpojo.excel.CellNotFoundException;
import net.w_horse.excelpojo.excel.cellseeker.AbstractCellSeeker.Offset;

import org.apache.poi.ss.usermodel.Sheet;

public interface CellSeeker extends Cloneable {

	/**
	 * Ame[Vp[T[ɒ`ZbgĂ炤
	 *
	 * @param annotation Ame[V
	 * @param parser Ame[Vp[T[
	 * @throws ClassNotFoundException listClassŖȃNXw肳Ăꍇ
	 * @throws LinkageError listClassŖȃNXw肳Ăꍇ
	 * @throws ExcelPOJOException ̑O
	 */
	void set(Annotation annotation, ExcelPOJOAnnotationParser parser) throws ClassNotFoundException, LinkageError, ExcelPOJOException;

	/**
	 * ŽsAl擾B
	 *
	 * @param sheet Ώہiǂݍ݁j̃V[g
	 * @param requiredType 擾ľ^
	 * @return Zʂ̒l
	 * @throws ClassNotFoundException listClassŖȃNXw肳Ăꍇ
	 * @throws LinkageError listClassŖȃNXw肳Ăꍇ
	 * @throws CellNotFoundException use="required"w肳ĂۂɃZȂꍇ
	 * @throws IllegalArgumentException `ɌEꍇ
	 * @throws ExcelPOJOException ̑O
	 */
	Object seekCellValue(Sheet sheet, Class<?> requiredType) throws ClassNotFoundException, LinkageError, CellNotFoundException, IllegalArgumentException, ExcelPOJOException;

	/**
	 * ŽsAlZbgB
	 *
	 * @param sheet Ώہi݁j̃V[g
	 * @param value ޒl
	 * @throws CellNotFoundException use="required"w肳ĂۂɃZȂꍇ
	 * @throws IllegalArgumentException `ɌEꍇ
	 * @throws ExcelPOJOException ̑O
	 */
	void setValue(Sheet sheet, Object value) throws CellNotFoundException, IllegalArgumentException, ExcelPOJOException;

	/**
	 * ŽsAlZbgB<br>
	 * _ZȂΈʒuw肵ĒlZbgB
	 *
	 * @param sheet ݑΏۂ̃V[g
	 * @param basePosition _
	 * @param offset Έʒu
	 * @param value l
	 * @throws CellNotFoundException use="required"w肳ĂۂɃZȂꍇ
	 * @throws ExcelPOJOException ̑O
	 */
	void setValue(Sheet sheet, Offset basePosition, Offset offset, Object value) throws CellNotFoundException, ExcelPOJOException;

	/**
	 * sɒ`ȇÓ`FbNs<br>
	 * `Ɍ▵ꍇ {@link IllegalArgumentException}
	 *
	 * @return true:Ó / false:肪iOj
	 * @throws IllegalArgumentException `Ɍ▵ꍇ
	 * @throws ExcelPOJOException listClassŖȃNXw肳Ăꍇ
	 */
	boolean verify() throws IllegalArgumentException, ExcelPOJOException;

	void setExcelPOJOBridge(ExcelPOJOBridge excelPOJOBridge);
	ExcelPOJOBridge getExcelPOJOBridge();
	void setUse(String use);
	String getUse();
	void setRange(String range);
	String getRange();
	void setConverter(CellFieldConverter converter);
	CellFieldConverter getConverter();
}
